/*
 * Decompiled with CFR 0.152.
 */
package com.printer.bluetooth.android;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.printer.bluetooth.android.BluetoothDiscover;
import com.printer.bluetooth.android.PrintGraphics;
import com.printer.bluetooth.android.PrinterType;
import com.printer.bluetooth.android.Table;
import com.printer.bluetooth.android.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BluetoothPrinter {
    private static final String TAG = "BluetoothPrinter";
    private boolean needVerify = false;
    private BluetoothDevice btDevice;
    private BluetoothSocket btSocket;
    private BluetoothAdapter btAdapt;
    private OutputStream sendStream;
    private InputStream receiveStream;
    private Handler printerHandler;
    public static final int Handler_Connect_Connecting = 100;
    public static final int Handler_Connect_Success = 101;
    public static final int Handler_Connect_Failed = 102;
    public static final int Handler_Connect_Closed = 103;
    public static final int Handler_Message_Error = 104;
    public static final int Handler_Message_Read = 105;
    private String printerName = "";
    private String macAddress = "";
    private String mEncoding;
    private boolean autoReceive = false;
    private boolean isConnected = false;
    private String SDK_Vesion = "2.3";
    private PrinterType currentPrintType = PrinterType.T9;
    private String companyTitle;
    private String companySubTitle;
    private Bitmap companyLogo;
    private List<String> tableData;
    private String tableReg;
    private String[] tableLine;
    private int two_dimensional_param1;
    private int two_dimensional_param2;
    private int two_dimensional_param3;
    private HashMap<Integer, String> unPrintColumnMap;
    private int[] tableColWidth;
    private byte currentBarCodeType;
    private final UUID PRINTER_UUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
    private final String printerCompanyName = "company";
    private String separator_T9 = "==============================================\n";
    private String separator_T3 = "==============================\n";
    public static final int COMM_INIT_PRINTER = 0;
    public static final int COMM_WAKE_PRINTER = 1;
    public static final int COMM_PRINT_AND_RETURN_STANDARD = 2;
    public static final int COMM_PRINT_AND_NEWLINE = 3;
    public static final int COMM_PRINT_AND_ENTER = 4;
    public static final int COMM_MOVE_NEXT_TAB_POSITION = 5;
    public static final int COMM_DEF_LINE_SPACING = 6;
    public static final int COMM_PRINT_AND_WAKE_PAPER_BY_LNCH = 0;
    public static final int COMM_PRINT_AND_WAKE_PAPER_BY_LINE = 1;
    public static final int COMM_CLOCKWISE_ROTATE_90 = 4;
    public static final int COMM_ALIGN = 13;
    public static final int COMM_ALIGN_LEFT = 0;
    public static final int COMM_ALIGN_CENTER = 1;
    public static final int COMM_ALIGN_RIGHT = 2;
    public static final int COMM_LINE_HEIGHT = 10;
    public static final int COMM_CHARACTER_RIGHT_MARGIN = 11;
    public static final byte BAR_CODE_TYPE_UPC_A = 0;
    public static final byte BAR_CODE_TYPE_UPC_E = 1;
    public static final byte BAR_CODE_TYPE_JAN13 = 2;
    public static final byte BAR_CODE_TYPE_JAN8 = 3;
    public static final byte BAR_CODE_TYPE_CODE39 = 4;
    public static final byte BAR_CODE_TYPE_ITF = 5;
    public static final byte BAR_CODE_TYPE_CODABAR = 6;
    public static final byte BAR_CODE_TYPE_CODE93 = 72;
    public static final byte BAR_CODE_TYPE_CODE128 = 73;
    public static final byte BAR_CODE_TYPE_PDF417 = 100;
    public static final byte BAR_CODE_TYPE_DATAMATRIX = 101;
    public static final byte BAR_CODE_TYPE_QRCODE = 102;

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String mEncoding) {
        this.mEncoding = mEncoding;
    }

    public void setAutoReceiveData(boolean auto) {
        this.autoReceive = auto;
    }

    public void setHandler(Handler mHandler) {
        this.printerHandler = mHandler;
    }

    public PrinterType getCurrentPrintType() {
        return this.currentPrintType;
    }

    public void setCurrentPrintType(PrinterType currentPrintType) {
        this.currentPrintType = currentPrintType;
    }

    public String getSDK_Vesion() {
        return this.SDK_Vesion;
    }

    public String getCompanyName() {
        return "company";
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    @Deprecated
    public String getFriendName() {
        return this.getPrinterName();
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public BluetoothPrinter(BluetoothDevice device) {
        this.btDevice = device;
        if (this.btDevice != null) {
            this.printerName = this.btDevice.getName();
            this.macAddress = this.btDevice.getAddress();
        }
    }

    public BluetoothPrinter(String macAddress, int flag) {
        this.btAdapt = BluetoothAdapter.getDefaultAdapter();
        try {
            this.btDevice = this.btAdapt.getRemoteDevice(macAddress.toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.btDevice = null;
        }
        if (this.btDevice != null) {
            this.printerName = this.btDevice.getName();
            macAddress = this.btDevice.getAddress();
        }
    }

    @Deprecated
    public BluetoothPrinter(String deviceName) {
        if (deviceName != null && !deviceName.equals("")) {
            this.btDevice = BluetoothDiscover.getBondedPrinterByName(deviceName);
            if (this.btDevice != null) {
                this.printerName = this.btDevice.getName();
                this.macAddress = this.btDevice.getAddress();
            }
        }
    }

    public boolean isPrinterNull() {
        return this.btDevice == null;
    }

    @Deprecated
    public int open() {
        this.openConnection();
        return 0;
    }

    public void openConnection() {
        if (this.printerHandler != null) {
            this.printerHandler.obtainMessage(100).sendToTarget();
        }
        new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block18: {
                    try {
                        BluetoothPrinter.this.btSocket = BluetoothPrinter.this.btDevice.createRfcommSocketToServiceRecord(BluetoothPrinter.this.PRINTER_UUID);
                        if (BluetoothPrinter.this.btSocket != null) {
                            BluetoothPrinter.this.btSocket.connect();
                            Log.i((String)BluetoothPrinter.TAG, (String)"connect establish, wait encryption verify");
                        }
                        BluetoothPrinter.this.sendStream = BluetoothPrinter.this.btSocket.getOutputStream();
                        BluetoothPrinter.this.receiveStream = BluetoothPrinter.this.btSocket.getInputStream();
                    }
                    catch (Exception e) {
                        Log.i((String)BluetoothPrinter.TAG, (String)"connect failed, wait reflect method or 4.0 method to retry..");
                        e.printStackTrace();
                        try {
                            int sdk = Integer.parseInt(Build.VERSION.SDK);
                            Log.i((String)BluetoothPrinter.TAG, (String)("sdk is.." + sdk));
                            if (sdk >= 14) {
                                BluetoothPrinter.this.btSocket = BluetoothPrinter.this.btDevice.createInsecureRfcommSocketToServiceRecord(BluetoothPrinter.this.PRINTER_UUID);
                                if (BluetoothPrinter.this.btSocket != null) {
                                    Log.i((String)BluetoothPrinter.TAG, (String)"4.0 method success, wait connect....");
                                    BluetoothPrinter.this.btSocket.connect();
                                    Log.i((String)BluetoothPrinter.TAG, (String)"connect establish, wait encryption verify");
                                }
                            }
                            Method method = BluetoothPrinter.this.btDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                            BluetoothPrinter.this.btSocket = (BluetoothSocket)method.invoke((Object)BluetoothPrinter.this.btDevice, 1);
                            if (BluetoothPrinter.this.btSocket != null) {
                                BluetoothPrinter.this.btSocket.connect();
                                Log.i((String)BluetoothPrinter.TAG, (String)"reflect success, connect establish, wait encryption verify");
                            }
                        }
                        catch (Exception e1) {
                            Log.i((String)BluetoothPrinter.TAG, (String)"all method connect failed, return.");
                            e1.printStackTrace();
                            BluetoothPrinter.this.closeConnection();
                            return;
                        }
                    }
                    if (BluetoothPrinter.this.needVerify) {
                        if (!BluetoothPrinter.this.verifyEncryption()) {
                            Log.i((String)BluetoothPrinter.TAG, (String)"encryption verify failed");
                            BluetoothPrinter.this.closeConnection();
                            return;
                        }
                        Log.i((String)BluetoothPrinter.TAG, (String)"encryption verify success");
                        BluetoothPrinter.this.isConnected = true;
                        if (BluetoothPrinter.this.printerHandler != null) {
                            BluetoothPrinter.this.printerHandler.obtainMessage(101).sendToTarget();
                        }
                    } else {
                        BluetoothPrinter.this.isConnected = true;
                        if (BluetoothPrinter.this.printerHandler != null) {
                            BluetoothPrinter.this.printerHandler.obtainMessage(101).sendToTarget();
                        }
                    }
                    if (BluetoothPrinter.this.autoReceive) {
                        try {
                            while (true) {
                                int bytes;
                                if ((bytes = BluetoothPrinter.this.receiveStream.available()) <= 0) {
                                    continue;
                                }
                                byte[] buffer = new byte[bytes];
                                BluetoothPrinter.this.receiveStream.available();
                                bytes = BluetoothPrinter.this.receiveStream.read(buffer);
                                if (BluetoothPrinter.this.printerHandler == null) continue;
                                BluetoothPrinter.this.printerHandler.obtainMessage(105, bytes, -1, (Object)buffer).sendToTarget();
                            }
                        }
                        catch (IOException e) {
                            if (BluetoothPrinter.this.printerHandler == null) break block18;
                            BluetoothPrinter.this.printerHandler.obtainMessage(104).sendToTarget();
                        }
                    }
                }
            }
        }.start();
    }

    private boolean verifyEncryption() {
        byte[] tmpData;
        block8: {
            tmpData = null;
            int receiveLength = 0;
            try {
                byte[] byArray = new byte[3];
                byArray[0] = 29;
                byArray[1] = 31;
                byte[] tmpSend = byArray;
                this.sendStream.write(tmpSend);
                this.sendStream.flush();
                receiveLength = this.receiveStream.available();
                int testTime = 15;
                while (receiveLength <= 0 && testTime-- > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    receiveLength = this.receiveStream.available();
                    Log.i((String)TAG, (String)("receiveStream length is : " + receiveLength));
                }
                if (receiveLength > 0) {
                    tmpData = new byte[receiveLength];
                    this.receiveStream.read(tmpData);
                    break block8;
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.i((String)TAG, (String)"receive input Stream error!");
                return false;
            }
        }
        String mac = this.btDevice.getAddress().replaceAll(":", "").toUpperCase();
        char[] tmpChar = mac.toCharArray();
        int CheckSum = 0;
        Log.i((String)TAG, (String)("btDevice.getAddress() is : " + this.btDevice.getAddress()));
        int i = 0;
        while (i < 12) {
            CheckSum += tmpChar[i] << 8 * (i % 4);
            ++i;
        }
        Log.i((String)TAG, (String)("CheckSum is : " + CheckSum));
        Log.i((String)TAG, (String)("CheckSum is(after ..) : " + (CheckSum ^= 0x53505254)));
        byte[] tmpResult = new byte[4];
        int j = 0;
        while (j < 4) {
            tmpResult[j] = (byte)(CheckSum >> (3 - j) * 8);
            ++j;
        }
        Log.i((String)TAG, (String)("receive tmpData[0] is : " + tmpData[0] + ", self tmpResult[0] is: " + tmpResult[0]));
        return tmpData[0] == tmpResult[0];
    }

    @Deprecated
    public int close() {
        this.closeConnection();
        return 0;
    }

    public void closeConnection() {
        try {
            if (this.btSocket != null) {
                this.btSocket.close();
            }
            this.btDevice = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.isConnected) {
            this.isConnected = false;
            if (this.printerHandler != null) {
                this.printerHandler.obtainMessage(103).sendToTarget();
            }
        }
    }

    public byte[] receive() {
        byte[] receiveData = null;
        try {
            int i = this.receiveStream.available();
            int testTime = 15;
            while (i <= 0 && testTime-- > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                i = this.receiveStream.available();
            }
            Log.i((String)TAG, (String)("receive()-->receiveStream length is : " + i));
            receiveData = new byte[i];
            this.receiveStream.read(receiveData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return receiveData;
    }

    @Deprecated
    public int send(String content) {
        return this.printText(content);
    }

    public int printText(String content) {
        if (content == null) {
            return -1;
        }
        try {
            this.sendStream.write(content.getBytes(this.mEncoding != null ? this.mEncoding : "GBK"));
            this.sendStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int printImage(String path) {
        if (path != null) {
            this.printByteData(Utils.bitmap2PrinterBytes(BitmapFactory.decodeFile((String)path), 0));
        }
        return -1;
    }

    public int printImage(String path, int left) {
        if (path != null) {
            this.printByteData(Utils.bitmap2PrinterBytes(BitmapFactory.decodeFile((String)path), left));
        }
        return -1;
    }

    public int printImage(Bitmap bitmap) {
        if (bitmap != null) {
            return this.printByteData(Utils.bitmap2PrinterBytes(bitmap, 0));
        }
        return -1;
    }

    public int printImageDot(String path, int multiple, int left) {
        if (path != null) {
            return this.printByteData(Utils.bitmap2PrinterBytesDot(BitmapFactory.decodeFile((String)path), multiple, left));
        }
        return -1;
    }

    public int printImageDot(Bitmap bitmap, int multiple, int left) {
        if (bitmap != null) {
            return this.printByteData(Utils.bitmap2PrinterBytesDot(bitmap, multiple, left));
        }
        return -1;
    }

    public int printImage(Bitmap bitmap, int left) {
        if (bitmap != null) {
            return this.printByteData(Utils.bitmap2PrinterBytes(bitmap, left));
        }
        return -1;
    }

    @Deprecated
    public int send(byte[] content) {
        return this.printByteData(content);
    }

    public int printByteData(byte[] content) {
        try {
            this.sendStream.write(content);
            this.sendStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public void init() {
        this.setPrinter(0);
    }

    public boolean setPrinter(int command) {
        byte[] arrayOfByte = null;
        switch (command) {
            case 0: {
                arrayOfByte = new byte[]{27, 64};
                break;
            }
            case 1: {
                arrayOfByte = new byte[]{0};
                break;
            }
            case 2: {
                arrayOfByte = new byte[]{12};
                break;
            }
            case 3: {
                arrayOfByte = new byte[]{10};
                break;
            }
            case 4: {
                arrayOfByte = new byte[]{13};
                break;
            }
            case 5: {
                arrayOfByte = new byte[]{9};
                break;
            }
            case 6: {
                arrayOfByte = new byte[]{27, 50};
            }
        }
        this.printByteData(arrayOfByte);
        return true;
    }

    public boolean setPrinter(int command, int value) {
        byte[] arrayOfByte = new byte[3];
        switch (command) {
            case 0: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 74;
                break;
            }
            case 1: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 100;
                break;
            }
            case 2: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 33;
                break;
            }
            case 3: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 85;
                break;
            }
            case 4: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 86;
                break;
            }
            case 5: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 87;
                break;
            }
            case 6: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 45;
                break;
            }
            case 7: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 43;
                break;
            }
            case 8: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 105;
                break;
            }
            case 9: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 99;
                break;
            }
            case 10: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 51;
                break;
            }
            case 11: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 32;
            }
            case 12: {
                arrayOfByte[0] = 28;
                arrayOfByte[1] = 80;
            }
            case 13: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 97;
                if (value <= 2 && value >= 0) break;
                return false;
            }
        }
        arrayOfByte[2] = (byte)value;
        this.printByteData(arrayOfByte);
        return true;
    }

    public void setCharacterMultiple(int x, int y) {
        byte[] arrayOfByte = new byte[3];
        arrayOfByte[0] = 29;
        arrayOfByte[1] = 33;
        if (x >= 0 && x <= 7 && y >= 0 && y <= 7) {
            arrayOfByte[2] = (byte)(x * 16 + y);
            this.printByteData(arrayOfByte);
        }
    }

    public void setLeftMargin(int nL, int nH) {
        byte[] arrayOfByte = new byte[]{29, 76, (byte)nL, (byte)nH};
        this.printByteData(arrayOfByte);
    }

    public void setPrintModel(boolean isBold, boolean isDoubleHeight, boolean isDoubleWidth, boolean isUnderLine) {
        byte[] arrayOfByte = new byte[3];
        arrayOfByte[0] = 27;
        arrayOfByte[1] = 33;
        int a = 0;
        if (isBold) {
            a += 8;
        }
        if (isDoubleHeight) {
            a += 16;
        }
        if (isDoubleHeight) {
            a += 32;
        }
        if (isDoubleHeight) {
            a += 128;
        }
        arrayOfByte[2] = (byte)a;
        this.printByteData(arrayOfByte);
    }

    public void setBarCode(int param1, int param2, int param3, byte type) {
        if (type == 100 || type == 101 || type == 102) {
            this.two_dimensional_param1 = param1;
            this.two_dimensional_param2 = param2;
            this.two_dimensional_param3 = param3;
        } else {
            byte[] command = new byte[]{29, 119, param1 >= 2 && param1 <= 6 ? (byte)param1 : (byte)2};
            this.printByteData(command);
            command[0] = 29;
            command[1] = 104;
            command[2] = param2 >= 1 && param2 <= 255 ? (int)param2 : -94;
            this.printByteData(command);
            command[0] = 29;
            command[1] = 72;
            command[2] = param3 >= 0 && param3 <= 3 ? (byte)param3 : (byte)0;
            this.printByteData(command);
        }
        this.currentBarCodeType = type;
    }

    /*
     * Unable to fully structure code
     */
    public void printBarCode(String content) {
        if (content == null) {
            return;
        }
        tempCommand = new byte[1024];
        index = 0;
        tempLength = strLength = content.length();
        tmpByte = content.getBytes();
        switch (this.currentBarCodeType) {
            case 100: 
            case 101: 
            case 102: {
                strArr = content.split(",");
                realCommand = new byte[strArr.length + 10];
                realCommand[0] = 29;
                realCommand[1] = 90;
                realCommand[2] = (byte)(this.currentBarCodeType - 100);
                realCommand[3] = 27;
                realCommand[4] = 90;
                realCommand[5] = (byte)this.two_dimensional_param1;
                realCommand[6] = (byte)this.two_dimensional_param2;
                realCommand[7] = (byte)this.two_dimensional_param3;
                realCommand[8] = (byte)(strArr.length % 256);
                realCommand[9] = (byte)(strArr.length / 256);
                i = 0;
                while (i < strArr.length) {
                    realCommand[10 + i] = (byte)Integer.parseInt(strArr[i]);
                    Log.i((String)"BluetoothPrinter", (String)strArr[i]);
                    ++i;
                }
                break;
            }
            case 73: {
                charArray = content.toCharArray();
                preHasCodeA = false;
                preHasCodeB = false;
                preHasCodeC = false;
                needCodeC = false;
                i = 0;
                while (i < strLength) {
                    a = (byte)charArray[i];
                    if (a < 0 || a > 31) ** GOTO lbl48
                    if (i == 0 || !preHasCodeA) {
                        tempCommand[index++] = 123;
                        tempCommand[index++] = 65;
                        preHasCodeA = true;
                        preHasCodeB = false;
                        preHasCodeC = false;
                        tempLength += 2;
                    }
                    tempCommand[index++] = a;
                    ** GOTO lbl81
lbl48:
                    // 1 sources

                    if (a < 48 || a > 57) ** GOTO lbl-1000
                    if (!preHasCodeC) {
                        m = 1;
                        while (m < 9) {
                            if (i + m != strLength && Utils.isNum((byte)charArray[i + m])) {
                                if (m == 8) {
                                    needCodeC = true;
                                }
                            } else {
                                needCodeC = false;
                                break;
                            }
                            ++m;
                        }
                    }
                    if (!needCodeC) ** GOTO lbl-1000
                    if (!preHasCodeC) {
                        tempCommand[index++] = 123;
                        tempCommand[index++] = 67;
                        preHasCodeA = false;
                        preHasCodeB = false;
                        preHasCodeC = true;
                        tempLength += 2;
                    }
                    if (i != strLength - 1 && Utils.isNum(b = (byte)charArray[i + 1])) {
                        tempCommand[index++] = (byte)((a - 48) * 10 + (b - 48));
                        --tempLength;
                        ++i;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if (!preHasCodeB) {
                            tempCommand[index++] = 123;
                            tempCommand[index++] = 66;
                            preHasCodeA = false;
                            preHasCodeB = true;
                            preHasCodeC = false;
                            tempLength += 2;
                        }
                        tempCommand[index++] = a;
                    }
lbl81:
                    // 3 sources

                    ++i;
                }
                realCommand = new byte[tempLength + 4];
                realCommand[0] = 29;
                realCommand[1] = 107;
                realCommand[2] = this.currentBarCodeType;
                realCommand[3] = (byte)tempLength;
                i = 0;
                while (i < tempLength) {
                    realCommand[i + 4] = tempCommand[i];
                    ++i;
                }
                break;
            }
            case 72: {
                realCommand = new byte[strLength + 4];
                realCommand[0] = 29;
                realCommand[1] = 107;
                realCommand[2] = this.currentBarCodeType;
                realCommand[3] = (byte)tempLength;
                j = 0;
                while (j < strLength) {
                    realCommand[4 + j] = tmpByte[j];
                    ++j;
                }
                break;
            }
            default: {
                realCommand = new byte[strLength + 4];
                realCommand[0] = 29;
                realCommand[1] = 107;
                realCommand[2] = this.currentBarCodeType;
                j = 0;
                while (j < content.length()) {
                    realCommand[3 + j] = tmpByte[j];
                    ++j;
                }
                realCommand[strLength + 3] = 0;
            }
        }
        sb = new StringBuffer();
        j = 0;
        while (j < realCommand.length) {
            temp = Integer.toHexString(realCommand[j] & 255);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            sb.append(String.valueOf(temp) + " ");
            ++j;
        }
        Log.i((String)"BluetoothPrinter", (String)("bar code command is : " + sb.toString()));
        this.printByteData(realCommand);
    }

    public void setTitle(String title, String subTitle, Bitmap logo) {
        this.companyTitle = title;
        this.companySubTitle = subTitle;
        this.companyLogo = logo != null ? (logo.getWidth() > 200 ? Utils.compressBitmap(logo, 100) : logo) : null;
    }

    public void printTitle() {
        if (this.companyTitle == null && this.companySubTitle == null && this.companyLogo == null) {
            return;
        }
        PrintGraphics pg = new PrintGraphics();
        pg.init(this.getCurrentPrintType());
        int titleTextSize = 0;
        float titlePX = 0.0f;
        if (this.companyTitle != null) {
            titleTextSize = 40;
            titlePX = (float)this.companyTitle.length() * pg.getCharacterWidth(titleTextSize);
            while (titlePX > (float)(pg.getWidth() - (this.companyLogo != null ? this.companyLogo.getWidth() : 0))) {
                titlePX = (float)this.companyTitle.length() * pg.getCharacterWidth(titleTextSize--);
            }
            pg.setTextSize(titleTextSize);
        }
        if (this.companyLogo != null) {
            Log.i((String)TAG, (String)("companyLogo.getWidth() is :" + this.companyLogo.getWidth() + "companyLogo.getHeight() is : " + this.companyLogo.getHeight()));
            if (this.companyTitle != null) {
                pg.drawImage(((float)(pg.getWidth() - this.companyLogo.getWidth()) - titlePX) / 2.0f, 10.0f, this.companyLogo);
                pg.drawText(((float)(pg.getWidth() - this.companyLogo.getWidth()) - titlePX) / 2.0f + (float)this.companyLogo.getWidth() + 5.0f, this.companyLogo.getHeight() + 5, this.companyTitle);
            } else {
                pg.drawImage((float)((pg.getWidth() - this.companyLogo.getWidth()) / 2), 0.0f, this.companyLogo);
            }
        } else if (this.companyTitle != null) {
            pg.drawText(((float)pg.getWidth() - titlePX) / 2.0f, 40.0f, this.companyTitle);
        }
        if (this.companySubTitle != null) {
            int subTitleSize = 25;
            titlePX = (float)this.companySubTitle.length() * pg.getCharacterWidth(subTitleSize);
            while (titlePX > (float)pg.getWidth()) {
                titlePX = (float)this.companySubTitle.length() * pg.getCharacterWidth(subTitleSize--);
            }
            pg.setTextSize(subTitleSize);
            pg.drawText(((float)pg.getWidth() - titlePX) / 2.0f, this.companyLogo != null ? this.companyLogo.getHeight() + 35 : 75, this.companySubTitle);
        }
        this.printImage(pg.getCanvasImage());
    }

    public void printTable(Table table) {
        if (table == null) {
            return;
        }
        this.tableReg = table.getRegularExpression();
        this.tableData = table.getTableData();
        this.tableColWidth = table.getColumnWidth();
        if (table.hasSeparator()) {
            if (this.currentPrintType == PrinterType.T9) {
                this.printText(this.separator_T9);
            } else {
                this.printText(this.separator_T3);
            }
        }
        int m = 0;
        while (m < this.tableData.size()) {
            this.tableLine = this.tableData.get(m).split(this.tableReg);
            this.unPrintColumnMap = null;
            this.printTableLine(this.tableLine);
            ++m;
        }
        if (table.hasSeparator()) {
            if (this.currentPrintType == PrinterType.T9) {
                this.printText(this.separator_T9);
            } else {
                this.printText(this.separator_T3);
            }
        }
    }

    private void printTableLine(String[] tableLine) {
        StringBuffer sb = new StringBuffer();
        int sub_length = 0;
        String[] line = tableLine;
        int i = 0;
        while (i < line.length) {
            int j;
            line[i] = line[i].trim();
            int index = line[i].indexOf("\n");
            if (index != -1) {
                if (this.unPrintColumnMap == null) {
                    this.unPrintColumnMap = new HashMap();
                }
                this.unPrintColumnMap.put(i, line[i].substring(index + 1));
                line[i] = line[i].substring(0, index);
                this.printTableLine(line);
                this.printNewLine(line);
                return;
            }
            int length = Utils.getStringCharacterLength(line[i]);
            int col_length = this.tableColWidth.length;
            int col_width = 8;
            if (i < col_length) {
                col_width = this.tableColWidth[i];
            }
            if (length > col_width) {
                sub_length = Utils.getSubLength(line[i], col_width);
                if (this.unPrintColumnMap == null) {
                    this.unPrintColumnMap = new HashMap();
                }
                this.unPrintColumnMap.put(i, line[i].substring(sub_length, line[i].length()));
                line[i] = line[i].substring(0, sub_length);
                this.printTableLine(line);
                this.printNewLine(line);
                return;
            }
            if (i == 0) {
                sb.append(line[i]);
                j = 0;
                while (j < col_width - length) {
                    sb.append(" ");
                    ++j;
                }
            } else {
                j = 0;
                while (j < col_width - length) {
                    sb.append(" ");
                    ++j;
                }
                sb.append(line[i]);
            }
            ++i;
        }
        this.printText(String.valueOf(sb.toString()) + "\n");
    }

    private void printNewLine(String[] oldLine) {
        if (this.unPrintColumnMap != null && this.unPrintColumnMap.size() > 0) {
            String[] newLine = new String[oldLine.length];
            for (Map.Entry<Integer, String> entry : this.unPrintColumnMap.entrySet()) {
                Integer key = entry.getKey();
                String value = entry.getValue();
                if (key >= oldLine.length) continue;
                newLine[key.intValue()] = value;
            }
            this.unPrintColumnMap = null;
            int i = 0;
            while (i < newLine.length) {
                if (newLine[i] == null || newLine[i] == "") {
                    newLine[i] = " ";
                }
                ++i;
            }
            this.printTableLine(newLine);
        }
    }
}

