/*
 * Decompiled with CFR 0.152.
 */
package com.printer.bluetooth.android;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import java.util.Set;

public class BluetoothDiscover {
    public static BluetoothDevice getBondedPrinterByName(String printerName) {
        Set<BluetoothDevice> devices = BluetoothDiscover.getBondedPrinters();
        if (devices.size() > 0) {
            for (BluetoothDevice device : devices) {
                String deviceName = device.getName();
                if (deviceName == null || !deviceName.toLowerCase().startsWith(printerName.toLowerCase())) continue;
                return device;
            }
        }
        return null;
    }

    public static Set<BluetoothDevice> getBondedPrinters() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        return adapter.getBondedDevices();
    }

    public static BluetoothDevice getPrinter(String macAddress) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        BluetoothDevice device = adapter.getRemoteDevice(macAddress);
        return device;
    }
}

