/*
 * Decompiled with CFR 0.152.
 */
package com.printer.bluetooth.android;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import com.printer.bluetooth.android.FontProperty;
import com.printer.bluetooth.android.PrinterType;
import com.printer.bluetooth.android.util.Utils;
import java.util.Locale;

public class PrintGraphics {
    private Canvas canvas = null;
    public Paint paint = null;
    private Bitmap bm = null;
    private int width;
    private float length = 0.0f;
    int intPicWidth = 0;

    public int getLength() {
        return (int)this.length;
    }

    public int getWidth() {
        return this.width;
    }

    public void initCanvas(int w) {
        int h = 5 * w;
        this.bm = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        this.canvas = new Canvas(this.bm);
        this.canvas.drawColor(-1);
        this.width = w;
    }

    public void initPaint() {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setColor(-16777216);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    public void init(PrinterType printerType) {
        if (printerType == PrinterType.T9) {
            this.initCanvas(576);
        } else if (printerType == PrinterType.T5) {
            this.initCanvas(240);
        } else {
            this.initCanvas(384);
        }
        this.initPaint();
    }

    public void setFontProperty(FontProperty fp) {
        if (fp.sFace != null) {
            try {
                this.paint.setTypeface(fp.sFace);
            }
            catch (Exception e) {
                this.paint.setTypeface(Typeface.DEFAULT);
            }
        } else {
            this.paint.setTypeface(Typeface.DEFAULT);
        }
        if (fp.bBold) {
            this.paint.setFakeBoldText(true);
        } else {
            this.paint.setFakeBoldText(false);
        }
        if (fp.bItalic) {
            this.paint.setTextSkewX(-0.5f);
        } else {
            this.paint.setTextSkewX(0.0f);
        }
        if (fp.bUnderLine) {
            this.paint.setUnderlineText(true);
        } else {
            this.paint.setUnderlineText(false);
        }
        if (fp.bStrikeout) {
            this.paint.setStrikeThruText(true);
        } else {
            this.paint.setStrikeThruText(false);
        }
        this.paint.setTextSize((float)fp.iSize);
    }

    public void setLineWidth(float w) {
        this.paint.setStrokeWidth(w);
    }

    public void setTextSize(int size) {
        this.paint.setTextSize((float)size);
    }

    public void setItalic(boolean italic) {
        if (italic) {
            this.paint.setTextSkewX(-0.5f);
        } else {
            this.paint.setTextSkewX(0.0f);
        }
    }

    public void setStrikeThruText(boolean strike) {
        this.paint.setStrikeThruText(strike);
    }

    public void setUnderlineText(boolean underline) {
        this.paint.setUnderlineText(underline);
    }

    public void setFakeBoldText(boolean fakeBold) {
        this.paint.setFakeBoldText(fakeBold);
    }

    public void drawText(float x, float y, String nStr) {
        this.canvas.drawText(nStr, x, y, this.paint);
        if (this.length < y) {
            this.length = y;
        }
    }

    public void drawLine(float startX, float startY, float stopX, float stopY) {
        this.canvas.drawLine(startX, startY, stopX, stopY, this.paint);
        float max = 0.0f;
        float f = max = startY > stopY ? startY : stopY;
        if (this.length < max) {
            this.length = max;
        }
    }

    public void drawRectangle(float left, float top, float right, float bottom) {
        this.canvas.drawRect(left, top, right, bottom, this.paint);
        float max = 0.0f;
        float f = max = top > bottom ? top : bottom;
        if (this.length < max) {
            this.length = max;
        }
    }

    public void drawEllips(float left, float top, float right, float bottom) {
        RectF re = new RectF(left, top, right, bottom);
        this.canvas.drawOval(re, this.paint);
        float max = 0.0f;
        float f = max = top > bottom ? top : bottom;
        if (this.length < max) {
            this.length = max;
        }
    }

    public void drawImage(float left, float top, String path) {
        try {
            Bitmap btm = BitmapFactory.decodeFile((String)path);
            this.canvas.drawBitmap(btm, left, top, null);
            if (this.length < top + (float)btm.getHeight()) {
                this.length = top + (float)btm.getHeight();
            }
            this.intPicWidth = btm.getWidth();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawImage(float left, float top, Context context, int imageId) {
        try {
            Bitmap btm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)imageId);
            this.canvas.drawBitmap(btm, left, top, null);
            if (this.length < top + (float)btm.getHeight()) {
                this.length = top + (float)btm.getHeight();
            }
            this.intPicWidth = btm.getWidth();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawImage(float left, float top, Bitmap image) {
        try {
            this.canvas.drawBitmap(image, left, top, null);
            if (this.length < top + (float)image.getHeight()) {
                this.length = top + (float)image.getHeight();
            }
            this.intPicWidth = image.getWidth();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int saveCanvasImage(String path) {
        return Utils.printBitmap2File(this.getCanvasImage(), path);
    }

    public Bitmap getCanvasImage() {
        return Bitmap.createBitmap((Bitmap)this.bm, (int)0, (int)0, (int)this.width, (int)this.getLength());
    }

    @Deprecated
    public void printPng() {
        this.saveCanvasImage("/sdcard/0.png");
    }

    @Deprecated
    public byte[] printDraw() {
        return Utils.bitmap2PrinterBytes(this.getCanvasImage(), 0);
    }

    @Deprecated
    public byte[] printDrawDot() {
        return Utils.bitmap2PrinterBytesDot(this.getCanvasImage(), 1, 0);
    }

    public float getCharacterWidth(int textSize) {
        float size = this.paint.getTextSize();
        this.paint.setTextSize((float)textSize);
        float spacing = this.paint.getFontSpacing();
        this.paint.setTextSize(size);
        String lang = Locale.getDefault().getLanguage();
        if (!(lang.equals("ja") || lang.equals("ko") || lang.equals("zh"))) {
            spacing /= 2.0f;
        }
        return spacing;
    }
}

